{include file="header.tpl" title="" keywords=$section.keywords description=$section.description}

{fetch_section assign=reglamentSection section=51 getContent=true}

<main class="main">

	<section class="flex:col">
		<div class="intro">

			<div class="intro__bg"><img src="{$ASSETS_URL}/images/bg/1.jpg" alt="{$section.name}"></div>

			<div class="flex:col-max">

				<div class="intro__content">

					<div class="intro__info">
						{if !empty($config.operating_mode)}
						<div class="intro__info-list">

							{assign var=operating value=" | "|explode:$config.operating_mode}
							<ul>
								{if is_array($operating)}
									<li>
										<svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M16.625 15.8335V4.75016C16.625 3.87695 15.9149 3.16683 15.0417 3.16683H13.4583V1.5835H11.875V3.16683H7.125V1.5835H5.54167V3.16683H3.95833C3.08512 3.16683 2.375 3.87695 2.375 4.75016V15.8335C2.375 16.7067 3.08512 17.4168 3.95833 17.4168H15.0417C15.9149 17.4168 16.625 16.7067 16.625 15.8335ZM7.125 14.2502H5.54167V12.6668H7.125V14.2502ZM7.125 11.0835H5.54167V9.50016H7.125V11.0835ZM10.2917 14.2502H8.70833V12.6668H10.2917V14.2502ZM10.2917 11.0835H8.70833V9.50016H10.2917V11.0835ZM13.4583 14.2502H11.875V12.6668H13.4583V14.2502ZM13.4583 11.0835H11.875V9.50016H13.4583V11.0835ZM15.0417 7.12516H3.95833V5.54183H15.0417V7.12516Z" fill="white" />
										</svg>
										{$operating[0]}
									</li>
									{if isset($operating[1])}
									<li>
										<svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M11.0002 19.2498C9.84236 18.2622 8.76917 17.1795 7.79183 16.0131C6.32516 14.2613 4.5835 11.6525 4.5835 9.16647C4.58286 7.89685 4.95888 6.65557 5.66397 5.59974C6.36905 4.54391 7.37151 3.72097 8.54448 3.23508C9.71744 2.74919 11.0082 2.62219 12.2534 2.87015C13.4985 3.11811 14.6421 3.72988 15.5395 4.62805C16.1369 5.22284 16.6105 5.93021 16.9327 6.70923C17.255 7.48824 17.4195 8.32344 17.4168 9.16647C17.4168 11.6525 15.6752 14.2613 14.2085 16.0131C13.2311 17.1795 12.158 18.2622 11.0002 19.2498ZM11.0002 6.41647C10.2708 6.41647 9.57134 6.7062 9.05562 7.22192C8.53989 7.73765 8.25016 8.43712 8.25016 9.16647C8.25016 9.89581 8.53989 10.5953 9.05562 11.111C9.57134 11.6267 10.2708 11.9165 11.0002 11.9165C11.7295 11.9165 12.429 11.6267 12.9447 11.111C13.4604 10.5953 13.7502 9.89581 13.7502 9.16647C13.7502 8.43712 13.4604 7.73765 12.9447 7.22192C12.429 6.7062 11.7295 6.41647 11.0002 6.41647Z" fill="white" />
										</svg>
										{$operating[1]}
									</li>
									{/if}
								{else}
									<li>
										<svg width="19" height="19" viewBox="0 0 19 19" fill="none" xmlns="http://www.w3.org/2000/svg">
											<path d="M16.625 15.8335V4.75016C16.625 3.87695 15.9149 3.16683 15.0417 3.16683H13.4583V1.5835H11.875V3.16683H7.125V1.5835H5.54167V3.16683H3.95833C3.08512 3.16683 2.375 3.87695 2.375 4.75016V15.8335C2.375 16.7067 3.08512 17.4168 3.95833 17.4168H15.0417C15.9149 17.4168 16.625 16.7067 16.625 15.8335ZM7.125 14.2502H5.54167V12.6668H7.125V14.2502ZM7.125 11.0835H5.54167V9.50016H7.125V11.0835ZM10.2917 14.2502H8.70833V12.6668H10.2917V14.2502ZM10.2917 11.0835H8.70833V9.50016H10.2917V11.0835ZM13.4583 14.2502H11.875V12.6668H13.4583V14.2502ZM13.4583 11.0835H11.875V9.50016H13.4583V11.0835ZM15.0417 7.12516H3.95833V5.54183H15.0417V7.12516Z" fill="white" />
										</svg>
										{$config.operating_mode}
									</li>
								{/if}
							</ul>
						</div>
						{/if}

						<div class="text-tmp color-white title-90 title-line after-title">
							<p>{$section.name nofilter}</p>
							<h1>{$section.alias nofilter}</h1>
							{$section.content nofilter}
						</div>

						<div class="btns">

							<a class="btn white large" href="{if isset($siteUser.userId)}{$SITE_URL}/add-application/{else}{$SITE_URL}/sign-in/{/if}">Подать заявку <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>

							{* Победители *}
{*							<a class="btn white large" href="https://marketing.uz/novosti/novosti-assotsiatsii/pobediteli-vi-premii-brend-goda-2023.htm"> Победители <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>*}

							{* Скачать регламент  *}
{*							{if !empty($reglamentSection) && !empty($reglamentSection.docs)}*}
{*								<a class="btn white large" href="{$reglamentSection.docs[0].original}" target="_blank">{$reglamentSection.name} <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>*}
{*							{/if}*}
							{* Задать вопрос *}
{*							<a class="btn white large" href="https://t.me/marketing_uz_Manager">Задать вопрос <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>*}
						</div>

					</div>

					<div class="intro__img">
						<img src="{$ASSETS_URL}/images/common/1.png" alt="">
					</div>

				</div>

			</div>

		</div>
	</section>

	{* Этапы премии *}
	{fetch_section assign=stagesSection section=6 getContent=true}{if !empty($stagesSection) && $stagesSection.status eq 'V'}
	<section class="flex:col pad-t-50 shadow-block bg-clip">
		<div class="flex:col pad-b-100 bg-accent-3">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-100">
					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp title-44 title-tt-up"><h2>{$stagesSection.name}</h2></div>
						<div class="grid:fr-3 max g-gap-20">
							{bracket_regex from=$stagesSection.content strip_tags=false}
							{foreach from=$regex item=item}
								<div class="step-card">
									<div class="step-card__head">
										<div class="text-tmp color-white title-20 all-center"><h2>{$item.code}</h2></div>
									</div>
									<div class="step-card__content">
										<div class="text-tmp txt-18 all-center">{$item.content nofilter}</div>
									</div>
								</div>
							{/foreach}
						</div>
					</div>
					{if !empty($stagesSection.alias)}

					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp title-44 title-tt-up">
                           <h2>Атмосфера MAKON Marketing Forum 2023</h2>
                        </div>
						
						<div class="media-block">
						    <iframe src="{$stagesSection.alias}" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
					    </div>
					</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* /Этапы премии *}

	{* Зачем брендам участвовать в премии? *}
	{fetch_section assign=whyParticipateSection section=7 getContent=true}{if !empty($whyParticipateSection) && $whyParticipateSection.status eq 'V'}
	<section class="flex:col pad-tb-100" id="about-award">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-44 title-tt-up txt-18"><h2>{$whyParticipateSection.name}</h2></div>
				{fetch_sections assign=infoSections from=$whyParticipateSection.sectionId status="V" getContent=true image=true}{if !empty($infoSections)}
				<div class="grid:fr-2 max g-gap-20">
					{assign var=a value=1}
					<div class="grid:fr-1 g-gap-20">
						{foreach item=infoSection from=$infoSections name=infoSections}
						<div class="desc-card">
							<div class="desc-card__head">
								<div class="desc-card__head-icon"><img src="{$infoSection.image.original}" alt="{$infoSection.name}"></div>
								<div class="text-tmp title-24"><h3>{$infoSection.name}</h3></div>
							</div>
							<div class="desc-card__info">
								<div class="text-tmp title-24 txt-18">{$infoSection.content nofilter}</div>
							</div>
						</div>
						{if $smarty.foreach.infoSections.iteration eq 2}
							{if !empty($reglamentSection) && !empty($reglamentSection.docs)}
								<a class="btn accent large x-center" href="{$reglamentSection.docs[0].original}" target="_blank">
									{$reglamentSection.name}
									<span>
										<svg xmlns="http://www.w3.org/2000/svg" height="24" viewBox="0 -960 960 960" width="24">
											<path d="M260-180.001q-82.922 0-141.461-57.615-58.538-57.615-58.538-140.538 0-73.384 47-130.538 47-57.153 119.923-67.614 13.539-73.154 79.808-136.808 66.269-63.654 143.269-63.654 24.538 0 42.268 17.731 17.73 17.73 17.73 42.268v266.617l73.232-72.001L625.384-480 480-334.616 334.616-480l42.153-42.153 73.232 72.001v-266.617q-75.616 8.615-122.808 69.461Q280-586.462 280-520h-20q-58 0-99 41t-41 99q0 58 41 99t99 41h480q42 0 71-29t29-71q0-42-29-71t-71-29h-60v-80q0-48.769-22-90.269-22-41.5-58-69.731v-70.306q65.153 33.077 102.576 95.23Q739.999-592.922 739.999-520v20.001h12.308q63.23 4.923 105.461 50.846Q899.999-403.23 899.999-340q0 66.922-46.538 113.461Q806.922-180.001 740-180.001H260Zm220-328.383Z" />
										</svg>
									</span>
								</a>
							{/if}

						{/if}
							{if $a eq 2}
					</div>
					<div class="grid:fr-1 g-gap-20">
						{assign var=a value=0}
						{/if}
						{assign var=a value=$a+1}
						{/foreach}

					</div>
				</div>
				{/if}
			</div>

		</div>
	</section>
	{/if}
	{* Зачем брендам участвовать в премии? *}

	{* Номинации *}
	{fetch_section assign=nominationSection section=3 getContent=true}{if !empty($nominationSection) && $nominationSection.status eq 'V'}
	<section class="flex:col bg-skyw shadow-block" id="{$nominationSection.fileName}">
		<div class="flex:col pad-tb-50 bg-accent-3">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-44 title-tt-up txt-18"><h2>{$nominationSection.name}</h2></div>
					{fetch_sections assign=nominations from=$nominationSection.sectionId status="V" getContent=true}{if !empty($nominations)}
					<div class="grid:fr-3 max g-gap-20 tab_js accard_js">
						{assign var=nominationsArr value=array_chunk($nominations, ceil(count($nominations)/3), true)}
						{foreach item=nominationItems from=$nominationsArr name=nominationsArr}
						<div class="grid:fr-1 g-gap-20">
							{foreach item=nomination from=$nominationItems name=nominationItems}
							<div class="accard">
								<button class="accard__btn tab-btn_js">{$nomination.alias}</button>
								<div class="accard__drop tab-drop_js">
									<div class="accard__drop-inner">
										<div class="text-tmp"><p>{$nomination.content|strip_tags nofilter}</p></div>
									</div>
								</div>
							</div>
							{/foreach}
						</div>
						{/foreach}
					</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	{/if}
	{* Номинации *}

	{* Экспертное жюри премии *}
	{fetch_section assign=jurySection section=4 getContent=true}{if !empty($jurySection) && $jurySection.status eq 'V'}
	<section class="flex:col pad-tb-100" id="{$jurySection.fileName}">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-100">
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-44 title-tt-up txt-18 max-w-1000">
						<h2>{$jurySection.name|replace:"Экспертное":"Экспертное <br>" nofilter}</h2>
						{$jurySection.content nofilter}
					</div>

					<div class="grid:fr-4 max g-gap-20">
						{fetch_articles limit=12 assign=judges image=true section=$jurySection.sectionId}
						{foreach from=$judges item=judge}
							{include file="items/item-judge.tpl"}
						{/foreach}
					</div>
				</div>

				<a class="btn accent large x-center" href="{$SITE_URL}{$jurySection.url}">
					Весь состав жюри <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span>
				</a>
			</div>
		</div>
	</section>
		{*<section class="flex:col pad-tb-100" id="{$jurySection.fileName}">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-100">
					<div class="grid:fr-1 g-gap-40">
						<div class="text-tmp title-44 title-tt-up txt-18 max-w-1000">
							<h2>{$jurySection.name|replace:"Экспертное":"Экспертное <br>" nofilter}</h2>
							{$jurySection.content nofilter}
						</div>

						<div class="grid:fr-4 max g-gap-20">
							<a class="persone-card" href="https://marketing.uz#partners">
								<div class="persone-card__img"><img src="/uploads/partners/26fe256b28c0.webp" alt="Партнеры Ассоциации"></div>
								<div>
									<div class="text-tmp title-20 all-center">
										<h3>Партнеры Ассоциации</h3>
									</div>
								</div>
							</a>
							<a class="persone-card" href="https://marketing.uz/eksperty-/eksperty-marketingovoj-assotsiatsii/">
								<div class="persone-card__img"><img src="/uploads/partners/26fe256b28c0.webp" alt="Эксперты Ассоциации"></div>
								<div>
									<div class="text-tmp title-20 all-center">
										<h3>Эксперты Ассоциации</h3>
									</div>
								</div>
							</a>
						</div>
					</div>
				</div>
			</div>
		</section>*}
	{/if}

	{* УЧАСТНИКИ ПРЕМИИ *}
	<section class="flex:col pad-b-50 bg-clip-bot shadow-block">
		<div class="flex:col pad-t-100 bg-accent-3">
			<div class="flex:col-max">
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-44 title-tt-up txt-18 max-w-1000">
						<h2>УЧАСТНИКИ ПРЕМИИ</h2>
					</div>
					{fetch_sections assign=nominations from=3 status="V" getContent=true}{if !empty($nominations)}
					<div class="grid:fr-1 g-gap-20">
						{foreach item=nomination from=$nominations name=nominations}
						{fetch_nominees_count assign=countJobs section=$nomination.sectionId}
						<a class="wide-line" href="{$SITE_URL}{$nomination.url}"><span>{$nomination.name}</span><span>{$countJobs.count}</span></a>
						{/foreach}
					</div>
					{/if}
				</div>
			</div>
		</div>
	</section>
	{* /УЧАСТНИКИ ПРЕМИИ *}

	<div class="banner">
		<div class="banner__img"><img src="{$ASSETS_URL}/images/bg/2.jpg" alt="Не упустите возможность"></div>
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-40">
				<div class="text-tmp title-44 txt-18 color-white all-center x-center max-w-768">
					<h2>Не упустите возможность</h2>
					<p>Пояснение о выгоде участия в премии Бренд года 2023</p>
				</div>
				<a class="btn white large x-center" href="{if isset($siteUser.userId)}{$SITE_URL}/add-application/{else}{$SITE_URL}/sign-in/{/if}">Подать заявку <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
			</div>
		</div>
	</div>

	{* Партнеры *}
	{fetch_sections assign=partnersSections from=5 status="V" image=true imageType='gallery'}{if !empty($partnersSections)}
	<section class="flex:col pad-tb-100" id="partners">
		<div class="flex:col-max">
			<div class="grid:fr-1 g-gap-100">
				{foreach item=partnersSection from=$partnersSections name=partnersSections}{if !empty($partnersSection.gallery)}
				<div class="grid:fr-1 g-gap-40">
					<div class="text-tmp title-40 all-center"><h2>{$partnersSection.name}</h2></div>
					<div class="cards">
						{foreach from=$partnersSection.gallery item=gallery}
							{if !empty($gallery.link)}
								<a href="{$gallery.link}" target="_blank" class="partners-card"><img src="{$gallery.original}" alt="{$gallery.title}"></a>
							{else}
								<div class="partners-card"><img src="{$gallery.original}" alt="{$gallery.title}"></div>
							{/if}
						{/foreach}
					</div>
				</div>
				{/if}{/foreach}
			</div>

		</div>
	</section>
	{/if}

</main>

{include file="footer.tpl"}