<!DOCTYPE html>
<html lang="{$config.website_language}">
<head>

    {include file="modules/meta.tpl"}
	{include file="modules/link.tpl"}

</head>
<body>

{if isset($siteUser.userId)}
	{assign var=authSection value=52}
{else}
	{assign var=authSection value=47}
{/if}
{fetch_section assign=signInSection section=$authSection}

{fetch_sections assign=headerMenus status="V" topMenu=1 level=1}

{fetch_section assign=logos section=1 status="V" image=true imageType='gallery'}

<header class="header header_js {if isset($section.sectionId) && $section.sectionId eq 1}{else}white-theme{/if}">
	<div class="flex:col-max">

		<div class="header__inner">
			{if !empty($logos) && !empty($logos.gallery)}
			<div class="header__logos">
				{foreach from=$logos.gallery item=gallery}
				<a href="{$gallery.link}"><img src="{$gallery.original}" alt="{$gallery.title}"></a>
				{/foreach}
			</div>
			{/if}
			<nav class="header__nav">
				<ul>
					{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
						<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}#{$headerMenu.fileName}{/if}">{$headerMenu.alias}</a></li>
					{/foreach}
				</ul>
			</nav>

			<div class="header__lang">
				<a href="{$GLOBAL_URL}/uz/">Uz</a>
			</div>

			{* авторизация / личный кабинет или голдосовать *}
			{if !empty($signInSection) && $signInSection.status eq 'V'}
				<a class="btn accent-1 small" href="{$SITE_URL}{$signInSection.url}">{$signInSection.alias} <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
			{else}
				<a class="btn accent-1 small" href="{$SITE_URL}">Голосовать <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
			{/if}
			{* авторизация / личный кабинет или голдосовать *}

			<button class="header__btn header-btn_js">
                <span class="burger-btn burger-btn_short">
                    <span class="burger-btn__item"></span>
                </span>
			</button>

		</div>

	</div>

	<div class="header-mob header-mob_js">
		<div class="header-mob__menu">

			<div class="header-mob__head">

				{if !empty($logos) && !empty($logos.gallery)}
					<div class="header-mob__logos">
						{foreach from=$logos.gallery item=gallery}
							<a href="{$gallery.link}"><img src="{$gallery.original}" alt="{$gallery.title}"></a>
						{/foreach}
					</div>
				{/if}

				<div class="header-mob__lang">
					<ul>
						<li><span>Ру</span></li>
						<li><a href="{$GLOBAL_URL}/uz/">Uz</a></li>
					</ul>
				</div>

			</div>

			<div class="header-mob__content">
				<div class="header-mob__nav">
					<ul>
						{foreach item=headerMenu from=$headerMenus name=headerMenus key=$key}
							<li><a {if isset($section.sectionId) && $section.sectionId eq $headerMenu.sectionId}class="active"{/if} href="{if !empty($headerMenu.externalLink)}{$headerMenu.externalLink}{else}{$SITE_URL}{$headerMenu.fileName}{/if}">{$headerMenu.alias}</a></li>
						{/foreach}
					</ul>
				</div>
			</div>

			<div class="header-mob__footer">

				<div class="social accent-1-theme">
					{include file="modules/socials.tpl"}
				</div>

				<div class="header-mob__contacts">
					<ul>
						<li>{mailto address=$config.email}</li>
						{assign var=phones value=", "|explode:$config.phone}
						{foreach from=$phones item=phone name=phones}
							<li><a href="tel:{$phone|strip_phone}">{$phone|format_phone}</a></li>
						{/foreach}

						<li>{$config.address}</li>
					</ul>
				</div>


				{* авторизация / личный кабинет или голдосовать *}
				{if !empty($signInSection) && $signInSection.status eq 'V'}
					<a class="btn accent-1 small" href="{$SITE_URL}{$signInSection.url}">{$signInSection.alias} <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
				{else}
					<a class="btn accent-1 small" href="{$SITE_URL}">Голосовать <span>{include file="icon/svg.tpl" svgId="next_icon" fill="none"}</span></a>
				{/if}
				{* авторизация / личный кабинет или голдосовать *}


			</div>

		</div>
	</div>

</header>