export const form = () => {
  let brand = new Validations("#brand"),
    copyBrand = new Validations("#copy"),
    login = new Validations("#login"),
    registration = new Validations("#registration"),
    validate = new Validations("#validate");

  brand.request((form) => {
    const formCurrent = $(`#${form.id}`),
      formAction = form.action,
      formMethod = form.method;

    let formData = new FormData(document.getElementById("brand"));

    $.ajax({
      url: formAction,
      type: formMethod,
      data: formData,
      contentType: false,
      processData: false,
      beforeSend: function () {
        new CreatePreloader(form.id);
      },
      success: function (response) {
        new RemovePreloader(form.id, response.message, response.status);
      },
      error: function (response) {
        new RemovePreloader(
          form.id,
          response.statusText + " " + response.responseText,
          response.status
        );
      },
      complete: function () {},
    });
  });

  let modalCopy;

  document.addEventListener("click", (e) => {
    let btn = e.target.closest(".table-add-namintaion_js");

    if (btn) {
      modalCopy = new Fancybox([
        {
          src: "#modalForm",
          type: "inline",
          autoFocus: false,
        },
      ]);
    }
  });

  copyBrand.request((form) => {
    const formCurrent = $(`#${form.id}`);

    $.post(
      formCurrent.attr("action"),
      formCurrent.serialize(),
      function (response) {
        notification(".notify", response.message, response.type);
        if (response.status == 200) {
          $(".nominees").prepend(response.data);
          modalCopy.close();
        }
      }
    );
  });

  login.request((form) => {
    const formCurrent = $(`#${form.id}`);
    console.log(form);

    $.post(
      formCurrent.attr("action"),
      formCurrent.serialize(),
      function (response) {
        if (response.status == 200) {
          if (response.sms) {
            hideForm("registration-block");
            showConfirmForm(
              "validate-block",
              ".confirm_notification",
              response.message,
              response.type
            );
            timer();
          } else {
            const notification = document.querySelector(".notification");
            notification.innerHTML = response.message;
            notification.classList.add(response.type);
            if (response.type == "error") {
              notification.style.color = "#c71f11";
            } else {
              notification.style.color = "#108424";
            }

            setTimeout(function () {
              notification.innerHTML = "";
              notification.classList.remove(response.type);
              window.location.href = response.redirect;
            }, 1500);
          }
        } else {
          notification(".notification", response.message, response.type);
        }
      }
    );
  });
  // регистрация
  registration.request((form) => {
    console.log(form);
    const formCurrent = $(`#${form.id}`);

    $.post(
      formCurrent.attr("action"),
      formCurrent.serialize(),
      function (response) {
        if (response.status == 200) {
          if (response.sms) {
            hideForm("registration-block");
            showConfirmForm(
              "validate-block",
              ".confirm_notification",
              response.message,
              response.type
            );
            timer();

            let block = document.querySelector("#validate-block");
            block.scrollIntoView();
          } else {
            const notification = document.querySelector(".notification");
            notification.innerHTML = response.message;
            notification.classList.add(response.type);
            if (response.type == "error") {
              notification.style.color = "#c71f11";
            } else {
              notification.style.color = "#108424";
            }

            setTimeout(function () {
              notification.innerHTML = "";
              notification.classList.remove(response.type);
              window.location.href = response.redirect;
            }, 1500);
          }
        } else {
          notification(".notification", response.message, response.type);
        }
      }
    );
  });

  // подтверждение
  validate.request((form) => {
    const formCurrent = $(`#${form.id}`);
    $.post(
      formCurrent.attr("action"),
      formCurrent.serialize(),
      function (response) {
        console.log(response);
        notification(".confirm_notification", response.message, response.type);
        if (response.status == 200) {
          setTimeout(function () {
            // window.location.replace(response.redirect);
            window.location.href = response.redirect;
          }, 1000);
        }
      }
    );
  });

  // уведомление
  function notification(element, message, type) {
    const notification = document.querySelector(element);
    notification.innerHTML = message;
    notification.classList.add(type);
    if (type == "error") {
      notification.style.color = "#c71f11";
    } else {
      notification.style.color = "#108424";
    }
    setTimeout(function () {
      notification.innerHTML = "";
      notification.classList.remove(type);
    }, 3500);
  }

  // скрыть форму
  function hideForm(id) {
    let form = document.getElementById(id);
    form.classList.add("d-none");
  }

  // показать форму подтверждения
  function showConfirmForm(id, element, message, type) {
    const form = document.getElementById(id);
    form.classList.remove("d-none");

    const notification = document.querySelector(element);
    notification.innerHTML = message;
    notification.classList.add(type);
    if (type == "error") {
      notification.style.color = "#c71f11";
    } else {
      notification.style.color = "#108424";
    }

    setTimeout(function () {
      notification.innerHTML = "";
      notification.classList.remove(type);
    }, 2500);
  }

  // timer
  function repeatPhoneSend() {
    let btnResend = document.querySelector(".resend_js");
    var resendForm = $(`#login`);

    btnResend.addEventListener("click", (e) => {
      $.post(
        resendForm.attr("action"),
        resendForm.serialize(),
        function (response) {
          if (response.status == 200) {
            timer();
          }
        }
      );
    });
  }

  function timer() {
    let form = document.querySelector(".form-call-timer_js");

    if (form) {
      let formBtn = form.querySelector(".form-call-btn_js"),
        formBtnPhone = form.querySelector(".resend_js"),
        timerNode = form.querySelectorAll(".form-timer"),
        count = 59,
        timer = document.createElement("div");

      formBtnPhone.classList.add("d-none");
      timer.classList.add("form-timer", "x-center");
      timerNode.forEach((element) => element.remove());
      formBtn.insertAdjacentElement("beforebegin", timer);
      timer.textContent = `00:${count}`;

      let intervalTimer = setInterval(() => {
        count--;
        if (count < 10) {
          count = `0${count}`;
        }

        timer.textContent = `00:${count}`;

        if (count <= 0) {
          formBtnPhone.classList.remove("d-none");
          timer.classList.add("d-none");
          repeatPhoneSend();
          clearInterval(intervalTimer);
        }
      }, 1000);
    }
  }
};
