<?php

require_once '../includes/visitor.inc.php';
include '../includes/admin-functions.inc.php';

global $userAuth;

use Mnv\Core\Config;
use Mnv\Core\Locale\I18N;
use Mnv\Modules\Jobs;

if (request()->ajax()) {

    $jobs = new Jobs();
    $error = false;

    $rewrite            = request()->get('rewrite');
    $jobs->brandId      = request()->get('brand');
    $jobs->nominationId = request()->get('nomination');

    if ($rewrite != Config::getValue('rewrite')) {
        header("HTTP/1.0 301 Moved Permanently");
        header("Location: " . SITE_URL);
        exit;
    }

    if (empty($jobs->nominationId)) {
        $jobs->response = array('status' => 403, 'type' => 'error', 'message' =>  I18N::locale("Вы не указали номинацию.", "Siz nominatsiyani bermadingiz.", "You didn't specify a nomination."));
        $error = true;
    }

    if (!empty($jobs->brandId) && !$error) {
        $jobs->response = $jobs->copy($userAuth->id());
    }

    return response()->json($jobs->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT)->send();

} else {
    die('Access denied!');
}
