<?php

require_once 'overall.inc.php';
use Mnv\Core\Config;
use Mnv\Core\Utilities\Cookie\Cookie;
use Mnv\Core\Utilities\Cookie\Session;
use Mnv\Core\Auth\Exceptions\UnknownIdException;
use Mnv\Models\Users\UserTypes;
use Mnv\Modules\User\Auth;

$adminIp = '';
$userIp = request()->ip();
if (!empty(Config::getValue('listIp'))) {
    $listIps = explode(",", Config::getValue('listIp'));
    foreach ($listIps as $listIp) {
        if ($listIp == $userIp) {
            $adminIp = $listIp;
        }
    }
}

/** если сайте отключен вывести шаблон или сообщение */
if (Config::getValue('website_down') == 0 && $adminIp == '') {
    header("HTTP/1.0 503 Service Unavailable");
    if (file_exists(THEME_ROOT.'/maintenance.tpl')) {
        $smarty->display('maintenance.tpl');
    } else {
        print "<html><head><title>Сервис недоступен</title><style> html, body {height : 100vh;width : 100%;overflow : hidden;margin: 0 auto;font-family: -apple-system,BlinkMacSystemFont,'Segoe UI',Roboto,Oxygen-Sans,Ubuntu,Cantarell,'Helvetica Neue',sans-serif;}.wrapper {height : 100%;width : 100%;padding: 0px;text-align: center;}.content {position:absolute; width:100%; top:50%;transform: translateY(-100%);}h3{color: #424242;font-weight: 400;}</style></head><body><div class='wrapper'><div class='content'><h3>".nl2br(Config::getValue('maintenance_message'))."</h3></div></div></body></html>";
    }
    exit;
}

//ini_set('session.gc_maxlifetime', 172800);
//ini_set('session.cookie_lifetime', 172800);


	/* сессия */
if (\session_status() == \PHP_SESSION_NONE) {
    // использовать файлы cookie для хранения идентификаторов сеансов
    \ini_set('session.use_cookies', 1);
    // использовать только файлы cookie (не отправлять идентификаторы сеанса в URL-адресах)
    \ini_set('session.use_only_cookies', 1);
    // не отправлять идентификаторы сеанса в URL-адресах
    \ini_set('session.use_trans_sid', 0);

    // запустить сеанс (запрашивает запись cookie на клиенте)
    @Session::start($visitorSessionName);
}

$smarty->assign('sessionId', Session::id());
Cookie::setcookie($visitorSessionName, Session::id(),time() + 604800, '/', '', '', true, 'Lax');

$userAuth = new Auth($userIp,false, $visitorSessionName);
$siteUser = [];
try {
    if ($userAuth->checkUser() && $userAuth->doesUserHaveRole($userAuth->id(), UserTypes::CUSTOMER)) {
        $siteUser = $userAuth->loadSiteUser($userAuth->id());
        $smarty->assign('siteUser', $siteUser);
    } else {
        $smarty->assign('siteUser', $siteUser);
        $userAuth->logOutUser();
    }
}  catch (UnknownIdException $e) {
    $userAuth->logOutUser();
}




?>