<?php

namespace Mnv\Modules\Participants;

use Mnv\Core\Locale\I18N;
use Mnv\Core\Utilities\Cookie\Session;
use Mnv\Core\Utilities\Curl\Curl;

/**
 * Class SmsGateway
 * @package Mnv\Modules\Participants
 */
class SmsGateway
{
    /** @var string */
    private string $table = 'customers';

    /** @var string  */
    private string $primaryKey = 'userId';


    private $sendUrl = 'http://91.204.239.44/broker-api/send';
    private $smsLogin = 'lifestyle';
    private $smsPass = 's0$EfPK#';

    private $config;

    public function __construct()
    {
        global $config;
        $this->config = $config;
    }

    /**
     * Добавление нового пользователя
     *
     * @param $userData
     * @return array
     */
    public function addNewUser($userData)
    {
        $userData['phone'] = preg_replace('/[^0-9]/', '', $userData['phone']);
        $userData['phone'] = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $userData['phone']);

        if (!connect($this->table)->select('phone')->where('phone', $userData['phone'])->getValue()) {
            $new_password                       = $this->randomInt(6);
            $userData['password']               = md5($new_password);
            $userData['ip']                     = $_SERVER['REMOTE_ADDR'];
            $userData['registeredOn']           = date('Y-m-d');
            $userData['status']                 = 'active';

//             print_r($userData);

            if ($userData['userId'] = connect($this->table)->insert($userData)) {
                Session::set('userPhone', $userData['phone']);
                $this->sendSms($userData['phone'], $new_password);
                return array('code' => 1, 'status' => 200, 'active' => 'phone', 'message' => I18N::locale(
                    "На Ваш номер $userData[phone] телефона выслан пароль для входа!",
                    "Sizning $userData[phone] telefon raqamingizga parol yuborildi!",
                    "A password has been sent to your $userData[phone] phone number!",
                ));
            } else {
                return array('code' => 0, 'status' => 403, 'message' => I18N::locale(
                    'Пользователь не сохранен!',
                    'Foydalanuvchi saqlanmadi!',
                    'The user is not saved!',
                ));
            }
        } else {
            return array('code' => 0, 'status' => 403, 'message' => I18N::locale(
                "Пользователь с таким номером $userData[phone] телефона уже существует...",
                "$userData[phone] telefon raqamiga o'xshash foydalanuvchi allaqachon mavjud ...",
                "A user with the same phone number $userData[phone] already exists ...",
            ));
        }
    }
//    /**
//     * Авторизация пользователя / Отправка SMS.
//     *
//     * @param $request
//     * @return array
//     * @throws Exception
//     */
//    public function signInPhone($request)
//    {
//        $request['login'] =  preg_replace('/[^0-9]/', '', $request['login']);
//        $request['phone'] = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $request['login']);
//
//        if ($this->checkPassword($request['login'], $request['password'])) {
//            $response = $this->sendSms($request['phone']);
//            if ($response['status'] === 200) {
//                connect($this->table)->where('login', $request['login'])->orWhere('phone', $request['phone'])->update([
//                    'smsCode' => $response['smsCode'],
//                    'smsActive' => 0,
//                ]);
//                Session::set('userPhone', $request['phone']);
//                return array('code' => 1, 'status' => 200, 'active' => 'phone', 'message' => I18N::locale('Вам телефон отправлен код подтверждения!', 'Вам телефон отправлен код подтверждения!', 'Вам телефон отправлен код подтверждения!'));
//            }
//        } else {
//            return array('code' => 0, 'status' => 403, 'message' => I18N::locale('Неправильный пароль!', 'Parol noto\'g\'ri!', 'Wrong password!'));
//        }
//    }

    /**
     * Проверка пароля
     *
     * @param $phone
     * @param $password
     * @return false
     */
    private function checkPassword($phone, $password)
    {
        $phone =  preg_replace('/[^0-9]/', '', $phone);
        $phone = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);

        $userPassword   = connect($this->table)->where('phone', $phone)->getValue();
        $password 	    = md5($password);
        return $userPassword == $password;
    }



//    /**
//     * Смена номера пользователя.
//     *
//     * @param $request
//     * @return array
//     * @throws Exception
//     */
//    public function updateUserTempPhone($request)
//    {
//        $request['phone']  = str_replace('+','', $request['phone']);
//
//        $user = dbQuery('customers', DB_ARRAY, array('fields' => 'userName, email, phone, instagram, city, address, client, password', 'where' => "userId = '$request[userId]'"));
//        // print_r($user);
//        $userUpdate['changePhoneSms'] 	    = $this->sendSms($request['phone']);
//        $userUpdate['changePhoneNumber'] 	= $user['phone'];
//
//        dbQuery('customers', DB_UPDATE, array('where' => "userId = '$request[userId]'", 'values' => $userUpdate));
//        $response['error'] 	= 0;
//        $status = 200;
//
//
//        return array('status' => $status, 'response' => $response);
//    }

    /**
     * Восстановление пароля.
     *
     * @param $phone
     * @return array
     * @throws \Exception
     */
    public function smsRecoveryPassword($phone)
    {
        $phone =  preg_replace('/[^0-9]/', '', $phone);
        $phone = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);

        if (connect($this->table)->select('phone')->where('phone', $phone)->getValue()) {
            $response = $this->sendSmsRecoveryPassword($phone);

            if (connect($this->table)->where('phone', $phone)->update(['password' => md5($response['password'])])) {
                return array('status' => 200, 'message' => I18N::locale(
                    "На Ваш номер $phone телефона выслан новый пароль!",
                    "Telefon $phone raqamingizga yangi parol yuborildi!",
                    "A new password has been sent to your phone $phone number!"
                ));
            } else {
                return array('status' => 400, 'message' => 'Error saving new password');
            }
        } else {

            return array('status' => 400, 'message' => I18N::locale(
                "Нет пользователя с таким номером $phone телефона",
                "Bu $phone raqamiga ega foydalanuvchi yo'q",
                "There is no user with this $phone number"
            ));
        }
    }

    /**
     * SMS-активация.
     *
     * @param $code
     * @return array
     */
    public function smsActivate($code)
    {
        $phone = '';
        if (Session::has('userPhone')) {
            $phone = Session::get('userPhone');
        }

        if ($userData = connect($this->table)->where('phone', $phone)->get('array')) {
            if ($userData['smsCode'] == $code) {
                if ($userData['smsActive'] == 1) {
                    return array('code' => 0, 'status' => 403, 'message' => 'Already activated');
                } else {
                    if (connect($this->table)->where('phone', $phone)->update(['smsActive' => 1, 'status' => 'active'])) {
                        Session::set('siteUser', $userData);
                        Session::delete('userPhone');
                        return array('code' => 1, 'status' => 200, 'message' => 'Добро пожаловать!');
                    }
                }
            } else {
                return array('code' => 0, 'status' => 403, 'message' => 'Code isn\'t correct');
            }
        } else {
            Session::delete('userPhone');
            return array('code' => 0,  'status' => 403, 'message' => "Пользователя с таким номером телефона $phone нет");
        }

    }

    /**
     *  Отправка смс с кодом активации
     *
     * @param $number
     * @return array
     */
    private function sendSms($number, $new_password)
    {
        $key = $new_password;
        $postData = array(
            'messages' => array(
                0 => array(
                    'recipient' => $number,
                    'message-id' => 'abc'.sprintf('%017d', rand(1, 99999999999999999)),
                    'sms' => array(
                        'originator' => '3700',
                        'content' => array(
//                            'text' => 'Ваш пароль для входа на сайт '.$this->config['website_name'].' : ' . $new_password
//                            'text' => 'Поздравляем! Вы успешно прошли регистрацию на сайте cardiocongress.uz как участник.Вход в личный кабинет Логин: '.$number.' Пароль : ' . $new_password
                            'text' => "Vi zaregestrirovalis na sayte cardiocongress.uz. Vashi dannie dlya vhoda: login: $number parol: $new_password . Nikomu ne soobshchayte kod podtverzhdeniya i ne udalyayte sms."
                        )
                    )
                )
            )
        );

        $data = $this->requestCurl($postData);
        if ($data == 'Request is received') {
            return array('status' => 200, 'smsCode' => $key);
        } else {
            return  array('status' => 401, 'error' => $data);
        }
    }

    /**
     * Отправка смс с новым паролем
     *
     * @param $number
     * @return array
     */
    private function sendSmsRecoveryPassword($number)
    {
        $password = $this->randomInt(6);
        $postData = array(
            'messages' => array(
                0 => array(
                    'recipient' => $number,
                    'message-id' => 'abc'.sprintf('%017d', rand(1, 99999999999999999)),
                    'sms' => array(
                        'originator' => '3700',
                        'content' => array(
//                            'text' => 'Ваш новый пароль: ' . $password
                            'text' => 'Vash noviy parol: ' . $password
                        )
                    )
                )
            )
        );

        $data = $this->requestCurl($postData);

        if ($data == 'Request is received') {
            return array('status' => 200, 'password' => $password);

        } else {
            return  array('status' => 401, 'error' => $data);
        }
    }

    /**
     * Отправка смс с новым паролем
     *
     * @param $number
     * @return array
     */
    public function sendingSmsInfo($number, $text)
    {
//        $number
        $postData = array(
            'messages' => array(
                0 => array(
                    'recipient' => $number,
                    'message-id' => 'abc'.sprintf('%017d', rand(1, 99999999999999999)),
                    'sms' => array(
                        'originator' => '3700',
                        'content' => array(
                            'text' => "$text"
                        )
                    )
                )
            )
        );

        $data = $this->requestCurl($postData);

        if ($data == 'Request is received') {
            return true;
        } else {
            return  false;
        }
    }

    /**
     * Отправка и получение ответа server
     *
     * @param $postData
     * @return string|null
     */
    private function requestCurl($postData)
    {
//        $postData = json_encode($postData, JSON_UNESCAPED_UNICODE);
        $curl = new Curl();
        $curl->setBasicAuthentication($this->smsLogin, $this->smsPass); // логин и пароль
        $curl->setHeader('Content-Type', 'application/json');
        $curl->post($this->sendUrl, $postData);
        if ($curl->error) {
            $curl->response = 'Error: ' . $curl->errorCode . ': ' . $curl->errorMessage;
        }

        return $curl->response;
    }


    /**
     * Валидация номера телефона регион Узбекистан
     *
     * @param $phone
     * @return array|bool
     */
    public function validatePhoneNumber($phone)
    {
        $phone =  preg_replace('/[^0-9]/', '', $phone);
        // Разрешить +, - и. в номере телефона
        if ($filtered_phone_number = filter_var($phone, FILTER_SANITIZE_NUMBER_INT)) {
            // Проверить длину номера
            if (strlen($filtered_phone_number) === 12) {
                return array('code' => 1, 'status' => true);
            } else {
                return array('code' => 0, 'status' => 403, 'message' => "Укажите полный номер телефона");
            }
        } else {
            return false;
        }
    }

    /**
     * Проверка паролей на достоверность
     *
     * @param $password
     * @param $password2
     * @return array|bool
     */
    private function checkUserPassword($password, $password2)
    {
        if ($password != $password2) {
            return array('code' => 0, 'message' => I18N::locale(
                'Данные поля Пароль и Подтверждение пароля различаются!',
                'Parol va parolni tasdiqlash uchun bu maydonlar boshqacha!',
                'These fields for Password and Confirm Password are different!',
            ));
        } else {
            return array('code' => 1);
        }
    }

    /**
     * Проверить существует ли пользователь с таким номером телефона `phone`
     *
     * @param $phone
     * @return array|bool
     */
    public function checkUserPhone($phone)
    {
        $phone = preg_replace('/[^0-9]/', '', $phone);
        $pregPhone = preg_replace('/([0-9]{3})([0-9]{2})([0-9]{3})([0-9]{2})([0-9]{2})/', '+$1 ($2) $3-$4-$5', $phone);

        if ($phoneUser = connect($this->table)->select('phone')->where('phone', $pregPhone)->getValue()) {
            return array('code' => 0, 'message' => I18N::locale(
                'C ' . $phoneUser . ' таким номером телефона пользователь уже существует!',
                'Bilan '. $phoneUser. 'foydalanuvchi bu telefon raqami bilan allaqachon mavjud!',
                'With ' . $phoneUser. ' the user already exists with this phone number!',
            ));
        } else {
            return true;
        }
    }

    /**
     * @param $len
     * @return string
     */
    private function randomInt($len)
    {
        $characters = '123456789';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $len; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }



    /**
     * @param $len
     * @return string
     */
    private function randomStr($len)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $len; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }


    /**
     * Генерация кода
     *
     * @param int $length
     * @param string $userName
     * @return bool|string
     */
    public function generateActivationCode($length = 8, $userName = '')
    {
        return substr(md5(time().'jashkdjh#*(UJLKF@H@)#$'. $userName), rand(1, 32-$length), $length);
    }


}
