<?php

namespace Mnv\Modules;

/**
 * Class Instagram
 */
class Instagram
{

    const URL_INSTAGRAM_API = 'https://graph.instagram.com/me/';

    private $access_token = 0;

    public $token_params = 0;
    public $count_post = 0;
    public $error = "";

    /**
     * Instagram constructor.
     * @param $token
     * @param int $count
     */
    public function __construct($token, $count = 10)
    {
        $this->token_params = $token;
        $this->count_post = $count;
    }

    /**
     * обработка токена
     */
    public function checkApiToken()
    {
        if (!strlen($this->token_params)) {
            $this->error="No API token instagram";
        }
        $this->access_token = '/?access_token='.$this->token_params;
    }

    /**
     * @param $method
     * @param string $fields
     * @return mixed
     */
    public function getFormatResult($method, $fields = '')
    {
        if (function_exists('curl_init')) {
            if ($fields) {
                $method.$this->access_token .= '&fields='.$fields;
            }
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, self::URL_INSTAGRAM_API.$method.$this->access_token."&limit=".$this->count_post);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER,true);
            $out = curl_exec($curl);
            $data =  $out ? $out : curl_error($curl);
        } else {
            $data = file_get_contents(self::URL_INSTAGRAM_API.$method.$this->access_token);
        }

        $data = json_decode($data, true);
        return $data;
    }

    /**
     * @return array|mixed
     */
    public function getInstagramPosts()
    {
        $this->checkApiToken();

        if ($this->error) {
            return array("ERROR" => "Y", "MESSAGE" => $this->error);
        }else{
            $data = $this->getFormatResult('media', 'id,caption,media_url,permalink,username,timestamp,thumbnail_url');
        }
        return $data;
    }

    /**
     * @return mixed|string
     */
    public function getInstagramUser()
    {
        $this->checkApiToken();
        if ($this->error) {
            return $this->error;
        } else {
            $data = $this->getFormatResult('users/self');
        }
        return $data;
    }

    /**
     * @param $tag
     * @return mixed|string
     */
    public function getInstagramTag($tag)
    {
        $this->checkApiToken();

        if ($this->error) {
            return $this->error;
        } else {
            $data = $this->getFormatResult('tag/'.$tag.'/media/recent');
        }
        return $data;
    }
}