<?php

namespace Mnv\Models\Users;


use Mnv\Core\Collections\Collection;

/**
 * Interface UserInterface
 * @package Mnv\Models\Users
 */
interface UserInterface
{

    /**
     * Получить пользователей
     *
     * @param string|null $orderBy  (optional)
     * @param int $limit
     * @param int $page
     * @return Collection
     */
    public function all(?string $orderBy, int $limit, int $page);

    /**
     * Получить кол-во пользователей
     */
    public function total(): void;

    /**
     * Удаление пользователя
     */
    public function remove(?string $userType);

    /**
     * Обновление статуса пользователя
     */
    public function approve();

    /**
     * Редактирование пользователя
     *
     * @return mixed
     */
    public function edit(?string $userType);

    /**
     * Добавление нового пользователя
     *
     * @param array $data
     * @return mixed
     */
    public function insert(array $data);

    /**
     * Обновление пользователя
     *
     * @param array $data
     * @return mixed
     */
    public function update(array $data);



}