<?php

namespace Mnv\Core;

use Mnv\Core\Database\Database;
use Mnv\Core\Singleton\SingletonTrait;

/**
 * Class DB
 * @package Mnv\Core
 */
final class DB extends Database
{
    use SingletonTrait;

    /** DB constructor. */
    private function __construct()
    {
        $databaseConfig = include GLOBAL_ROOT .'/includes/config.inc.php';

        parent::__construct($databaseConfig);
    }

    /**  @return Database  */
    public function connect(): Database
    {
        return $this;
    }



}