
	<!-- Page header -->
	{capture name="buttons"}
	{/capture}

	{capture name="breadcrumb"}
		<a href="{$adminUrl}/visitors" class="breadcrumb-item">{$title}</a>
	{/capture}

	{capture name="showBy"}
	    {include file="module/show-by.tpl" url="{$adminUrl}/visitors"}
	{/capture}

	{include file="components/page-header.tpl" buttons=$smarty.capture.buttons breadcrumb=$smarty.capture.breadcrumb showBy=$smarty.capture.showBy}
	<!-- /page header -->

	<div class="content">
	    <div class="row">
	        <div class="col-md-12">
		        <div class="card border shadow-sm">
			        {include file="views/stats/form/selectors.tpl" action="{$adminUrl}/visitors" select=''}
		        </div>

	            <div class="card border shadow-sm">
		            <div class="card-header d-flex flex-wrap">
			            <h6 class="mb-0">{$title}</h6>
			            <div class="d-inline-flex ms-auto">
				            <a class="text-body" data-card-action="collapse"><i class="ph-caret-down"></i></a>
			            </div>
		            </div>
		            <div class="collapse show">
	                    <table class="table table-xs table-striped table-actions table-hover">
	                    <thead>
	                        <tr>
	                            <th class="text-center">{stats:firstVisit}</th>
	                            <th class="text-left">{stats:referer}</th>
	                            <th class="text-center">{stats:visits}</th>
	                        </tr>
	                    </thead>
	                    {if isset($visitors) && !empty($visitors)}
	                        <tbody>
	                            {foreach item=visitor from=$visitors}
	                                <tr class="">
	                                    <td class="text-nowrap">{$visitor.firstVisitOn}</td>
	                                    <td class="text-left" width="100%">
	                                        {if isset($visitor.refererWebsite)}
	                                            <a href="{$visitor.referer}" target="_blank">{$visitor.refererWebsite|truncate:30}</a>
	                                            {if isset($visitor.searchPhrase)} ({$visitor.searchPhrase|truncate:50}){/if}
	                                        {elseif isset($visitor.refererUrl)}
	                                            <a href="{$visitor.refererUrl}" target="_blank">{$visitor.refererUrl|truncate:80}</a>
	                                        {/if}
	                                    </td>
	                                    <td class="text-center">
	                                        <a href="{$adminUrl}/visitor?visitorId={$visitor.visitorId}{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}">{$visitor.totalVisits}</a>
	                                    </td>

	                                </tr>
	                            {/foreach}
	                        </tbody>
	                        {else}
	                            <tbody><tr class="odd"><td class="text-center" colspan="4">- {general:none} -</td></tr></tbody>
	                        {/if}

	                </table>
		            </div>
	                {include file="module/pagination.tpl" url="{$adminUrl}/visitors" params="{if isset($filterTypeId)}&filterTypeId={$filterTypeId}{/if}{if isset($domain)}&domain={$domain}{/if}"}
	            </div>
	        </div>
	    </div>
	</div>
	<!-- /content area -->
