<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Filesystem\FilesystemManager;
use Mnv\Core\Uploads\Uploader;

/**
 * Class UploadsAdmin
 * @package Mnv\Admin\Controllers
 */
class UploadsAdmin extends AdminMnv
{
    // TODO: Сделать сортировку по дате (и по расширению)

    public function fetch()
    {
        $options = [];
        $path       = $this->request->get('path', '/');
        $folder     = $this->request->get('folder', '');
        $fileIds    = $this->request->get('fileIds', '');

        $name     = $this->request->get('name','');
        $query    = $this->request->get('query','');
        $type     = $this->request->get('type', '');
        $filters  = $this->request->get('filters', '');


//        // TODO: продумать логику кеширования последней позиции директории
//        if (checkRelativePath($path)) {
//            $subdir = strip_tags($path) . "/";
//        } else {
//            $subdir = '';
//        }
//
//        if ($subdir == "") {
//            if (!empty($_COOKIE['last_position']) && strpos($_COOKIE['last_position'], '.') === false) {
//                $subdir = trim($_COOKIE['last_position']);
//            }
//        }
//        //remember last position
//        setcookie('last_position', $subdir, time() + (86400 * 7));
//
//        if ($subdir == "/") {
//            $subdir = "";
//        }

//        print_r($subdir);

        $filesystem = new FilesystemManager('/uploads', $path);
        $this->smarty->assign('path', $filesystem->path);

        /** добавление новой директории */
        if ($this->action == 'new_folder') {
            if (!preg_match('/[^0-9a-zA-Z\-_\. ]/i', $name)) {
                if (!$filesystem->isDirectory($filesystem->realPath . $name)) {
                    if ($filesystem->makeDirectory($filesystem->realPath . $name)) {
                        /** directory large */
                        $filesystem->makeDirectory($filesystem->realPath . $name . '/large');
                        /** directory medium */
                        $filesystem->makeDirectory($filesystem->realPath . $name . '/medium');
                        /** directory small */
                        $filesystem->makeDirectory($filesystem->realPath . $name . '/small');
                    }

                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:0'));
                }
            } else {
                $this->response = array('status' => 500, 'error' => lang('fileManager:errors:5'));
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление директории если она пустая */
        else if ($this->action == 'delete_folder') {

            if ($filesystem->exists($filesystem->realPath . $folder)) {
                $files = $filesystem->allFiles($filesystem->realPath . $folder);
                if (empty($files)) {
                    $filesystem->deleteDirectory($filesystem->realPath . $folder);
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:3'), 'folder' => $filesystem->realPath . $folder);
                } else {
//                    $this->response = array('status' => 500, 'message' => lang('fileManager:errors:3'), 'folder' => $filesystem->realPath . $folder);
                    $this->response = array('status' => 500, 'message' => lang('fileManager:directoryNotEmpty'), 'folder' =>$filesystem->realPath . $folder);
                }
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление директории с подтверждением если она не пустая */
        else if ($this->action == 'confirm_remove_folder') {
            if ($filesystem->exists($filesystem->realPath . $folder)) {
                $files = $filesystem->allFiles($filesystem->realPath . $folder);
                if (!empty($files)) {
                    foreach ($files as $file) {
                        $childDirectory = $filesystem->basename($file->getPath());
                        if (!in_array($childDirectory, FilesystemManager::$_hidden_image_folders)) {
                            $filesystem->deleteAllFilesThisDirectory($childDirectory);
                        }
                    }
                }
                $filesystem->deleteDirectory($filesystem->realPath . $folder);
                $this->response = array('status' => 200, 'message' => lang('fileManager:messages:3'), 'folder' => $filesystem->realPath . $folder);
            } else {
                $this->response = array('status' => 500, 'message' => lang('fileManager:errors:3'), 'folder' => $filesystem->realPath . $folder);
            }
            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление файла / удаление файлов */
        else if ($this->action == 'remove') {
            if (!empty($fileIds)) {
                if ($filesystem->deleteFiles($fileIds)) {
                    $this->response = array('status' => 200, 'message' => lang('fileManager:messages:9'));
                } else {
                    $this->response = array('status' => 500, 'message' => lang('fileManager:errors:12'));
                }
            } else {
                $this->response = array('status' => 500, 'message' => 'Пустой ID файла, ищите ошибку)');
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** загрузка файлов новая версия */
        else if ($this->action == 'upload') {

            $upload = new Uploader($options, $filesystem->realPath, $filesystem->path, $this->manager['userId']);
            if ($upload->validate()) {
                $upload->upload();
            }


            response()->json($upload->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }


        /** получение всего что есть в папке uploads */
        else if ($this->action == 'read_more') {

//            print_r($filesystem->realPath);
            if ($filesystem->exists($filesystem->realPath)) {
                $list['dirs']       = $filesystem->getDirectories(FilesystemManager::$_hidden_image_folders, true);
                $where['directory'] = $filesystem->basename($filesystem->realPath);
                $list['files']      = $filesystem->all($where, $query, $filters, $type, $this->manager['userId'], $this->limit = 28, $this->page);

                $this->smarty->assign('list', $list);

                response($this->smarty->fetch('module/uploads-file-list.tpl'))->send();
            } else {
                $this->response = array('status' => 403, 'error' => 'Такая директория не найдена');
                response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            }
            exit();
        }
        /** подгрузка файлов при скролле блока */
        else if ($this->action == 'read_more_files') {
            $where['directory'] = $filesystem->basename($filesystem->realPath);
            if ($list['files'] = $filesystem->all($where, $query, $filters, $type, $this->manager['userId'], $this->limit = 28, $this->page)) {
                $this->smarty->assign('list', $list);
                $items = $this->smarty->fetch('module/uploads-file-list.tpl');

                $this->response = array('status' => 200, 'items'=> $items, 'directory' => $where['directory']);
            }  else {
                $this->response = array('status' => 403, 'items'=> '', 'directory' => $where['directory']);
            }

            response()->json($this->response, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();

        }

        /** получение файла по конкретному запросу */
        else if ($this->action == 'get_file') {

            $listArr = array();

            if (!empty($fileIds)) {
                foreach ($fileIds as $id) {
                    $listArr[] = $filesystem->read($id);
                }
            }

            response()->json($listArr, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => $this->config['charset']], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
    }
}

/**
 * Check relative path / Проверьте относительный путь
 *
 * @param string $path
 *
 * @return boolean is it correct?
 */
function checkRelativePath($path)
{
    $path_correct = checkRelativePathPartial($path);
    if ($path_correct) {
        $path_decoded = rawurldecode($path);
        $path_correct = checkRelativePathPartial($path_decoded);
    }
    return $path_correct;
}

/**
 * @param $path
 * @return bool
 */
function checkRelativePathPartial($path)
{
    if (strpos($path, '../') !== false
        || strpos($path, './') !== false
        || strpos($path, '/..') !== false
        || strpos($path, '..\\') !== false
        || strpos($path, '\\..') !== false
        || strpos($path, '.\\') !== false
        || $path === ".."
    ) {
        return false;
    }
    return true;
}
	
