<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) die('Hacking attempt!');

use Mnv\Core\AdminMnv;

use Mnv\Models\Users\UserTypes;
use Mnv\Models\TypeContent;
use Mnv\Models\TypeContentField;

/**
 * Class TypeContentsAdmin
 */
class TypeContentsAdmin extends AdminMnv
{

    public function fetch()
    {

        $typeContent = new TypeContent($this->request);

        $this->smarty->assign('activeItem','typecontents');
        $this->smarty->assign('title', 'Тип контента');
        /** statuses */
        $this->smarty->assign('statuses', lang('general:statuses'));


        if ($this->action == 'remove') {
            $result =$typeContent->remove()
                ? array('status' => 200, 'message' => 'Тип контента удален', 'type' => 'success')
                : array('status' => 403, 'message' => 'Ошибка при удаление типа контента', 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }
        else if ($this->action == 'reorder') {

            $i = 0;
            foreach ($typeContent->typeIds as $type) {
                $i++;
                $typeContent->id = $type['id'];
                $typeContent->data['orderBy']  = $i;
                $typeContent->data['fileName'] = $type['fileName'];
                $typeContent->update($typeContent->data);
            }

            response()->json(array('status' => 200, 'message' => "Тип контента перемещен", 'type' => 'success'), \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit;
        }
        /** изменение статуса */
        else if ($this->action === 'status') {

            $result = $typeContent->status()
                ? array('data' => true, 'status' => $this->status, 'type' => 'success')
                : array('data' => false, 'status' => $this->status, 'type' => 'error');
            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** получение всех менеджеров с картинками */
        $types = collect($typeContent->all($this->limit = 30, $this->page))->map(function ($item) {
            $item['statusName'] = lang('general:statuses:' . $item['status']);

            return $item;
        })->all();

        /** pagination */
        $typeContent->total();
        $pages = getPageNums($typeContent->total, $this->page, $this->limit, 0, 4, 4, 0);

        $this->smarty->assign('types', $types);
        $this->smarty->assign('pageNums', $pages);

        if (!empty($this->errors)) $this->smarty->assign('errors', $this->errors);
        if (!empty($this->messages)) $this->smarty->assign('messages', $this->messages);


        /** Права доступа к данному шаблону */
        if ($this->manager['userType'] == UserTypes::DEVELOPER) {
            return $this->smarty->fetch('views/type-content/contents.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');

    }
}



