<?php

namespace Mnv\Admin\Controllers;

if (!defined('MNV_CMS')) {
    die('Hacking attempt!');
}

use Mnv\Core\AdminMnv;
use Mnv\Core\Config;
use Mnv\Core\Helpers;

use Mnv\Models\Jobs;

/**
 * Class JobAdmin
 * @package Mnv\Admin\Controllers
 */
class JobAdmin extends AdminMnv
{
    /**
     * Вывод всего контента
     */
    public function fetch()
    {
        global $LANGUAGES, $SECTIONS;

        $block = new Jobs($this->request);

        $image    = $this->request->get('image', '');
        $docs       = $this->request->get('docs', '');
        $imageIds = $this->request->get('imageIds', '');
        $imageId  = (int) $this->request->get('imageId', '');

//        print_r($this->request);
        /** title */
        $this->smarty->assign('title', 'Работа');
        /** activeItem */
        $this->smarty->assign('activeItem', 'jobs');
        /** statuses */
        $statuses = lang('general:statuses');
        array_shift($statuses);
        array_pop($statuses);
        $this->smarty->assign('statuses', $statuses);
        $this->smarty->assign('paramIsFeatured', $block->paramIsFeatured);
        $this->smarty->assign('languages', $LANGUAGES);
        $adminLanguage = Config::getValue('website_language');
        $this->smarty->assign('adminLanguage', $adminLanguage);

        $sections = Helpers::getSectionContent(0, 'nominations');
        if (count($sections) < 2) $this->errors['no_sections'] = true;
        $this->smarty->assign('sections', $sections);


        if ($this->action == 'add' || $this->action == 'edit') {
            $block->edit()->gettingInfoAboutUsers();
        } else if ($this->action == 'save' || $this->action == 'apply') {

            /** Проверка полей */
            if (empty($block->data['brand'])) $this->errors['brand'] = true;

            /** Проверка доступных разделов для статей */
            if (empty($block->data['sectionId']) || empty($sections[$block->data['sectionId']])) $this->errors['sectionId'] = true;

            /** Проверка fileName на совпадение / если пустой то fileName пропишется от последнего ID из таблицы + 1 */
            if (!empty($block->data['fileName'])) {
                if (preg_match('/^(page\d+|index)$/i', $block->data['fileName'])) $this->errors['fileNameProhibited'] = true;
                if (preg_match('/[^0-9a-zA-Z\-_\.,]/i', $block->data['fileName'])) $this->errors['fileNameCharacters'] = true;
            }

            if (empty($this->errors)) {
                if ($fileName = $block->checkFileName($block->data['fileName'])) {
                    if ($fileName == $block->data['fileName']) {
                        $this->errors['fileNameExists'] = true;
                    } else {
                        $block->data['fileName'] = $fileName;
                    }
                }
            }

            /** Основная картинка */
            $images['fileId'] = !empty($image) ? $image['fileId'] : null;
            if (isset($docs)) $images['docs'] = !empty($docs) ? $docs : '';

            /** Если ошибок нет, то можно продолжить дальше */
            if (empty($this->errors)) {
//                if (empty($block->data['fileName'])) $block->data['fileName'] = $block->getMaxId();
                $block->data['url'] = $SECTIONS[$block->data['sectionId']]['path'] . '/' . $block->data['fileName'] . '.' . $this->config['file_extension'];

                if ($block->prepare($block->data, $this->manager['userId'], $LANGUAGES)) {
                    if (!empty($images['fileId'])) $block->addMainImage($block->id, $images);

                    if (!empty($images['docs'])) $block->addPdf($block->id, $images);
                    $this->messages['saved'] = true;
                } else {
                    $this->errors['not_saved'] = true;
                }
            }

            $block->edit()->gettingInfoAboutUsers();

            if (empty($this->errors) && $this->action == 'save') {
                redirect($this->adminUrl . "/jobs?" . $this->buildQueryString(['page' => $this->page]));
            }

        }
        /** Удаление основной картинки */
        else if ($this->action == 'deleteImage') {
            $result = $block->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingImage'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingImageError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

        /** удаление файлов docs */
        else if ($this->action == 'deletePdf') {

            $result = $block->deleteFile($imageId)
                ? array('status' => 200, 'message' => lang('javascript:deletingDocs'), 'type' => 'success')
                : array('status' => 500, 'message' => lang('javascript:deletingDocsError'), 'type' => 'error');

            response()->json($result, \Mnv\Http\Response::HTTP_OK, ['Content-Type' => 'application/json;charset=UTF-8', 'Charset' => 'utf-8'], JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES|JSON_PRETTY_PRINT)->send();
            exit();
        }

//        print_r($block->data);
        $this->smarty->assign('job', $block->data);


        if (!empty($this->errors)) {
            $this->smarty->assign('errors', $this->errors);
        }
        if (!empty($this->messages)) {
            $this->smarty->assign('messages', $this->messages);
        }

        if ($this->permissions('jobs')) {
            return $this->smarty->fetch('views/jobs/job.tpl');
        }

        $this->smarty->assign('title', 'Access Denied');
        return $this->smarty->fetch('accessIsDenied.tpl');
    }



}